package ru.uss.vstore.localserver;

import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

/**
 * Ответ за запрос подписания данных XML в формате XMLDsig
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "DocumentXmlSignatureResponse")
public class DocumentXmlSignatureResponse {

    @XmlElement
    @Documentation("Подписанные данные")
    private String signedXmlData;

    public DocumentXmlSignatureResponse(){}

    public DocumentXmlSignatureResponse(String signedXmlData) {
        this.signedXmlData = signedXmlData;
    }

    public String getSignedXmlData() {
        return signedXmlData;
    }

    public void setSignedXmlData(String signedXmlData) {
        this.signedXmlData = signedXmlData;
    }
}
